package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费控佳费用类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-23
 */
public enum FkjExpensesTypeEnum {

    OUT_COOP_SERVICE("outCoopService", "外协服务"),
    SERVICE("service", "服务费"),
    TRAVEL("travel", "差旅费"),
    WELFARE("welfare", "福利费"),
    OFFICE("office", "办公费"),
    BUYER("buyer", "资产采购"),
    ENTERTAIN("entertain", "业务招待费"),
    MARKET("market", "市场活动费"),
    NON_BUDGET("nonBudget", "非预算类"),
    NOT_FOUND("notFound", "未找到费用大类");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FkjExpensesTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FkjExpensesTypeEnum fromCode(String code){
        switch(code) {
            case "outCoopService":
                return OUT_COOP_SERVICE;
            case "service":
                return SERVICE;
            case "travel":
                return TRAVEL;
            case "welfare":
                return WELFARE;
            case "office":
                return OFFICE;
            case "buyer":
                return BUYER;
            case "entertain":
                return ENTERTAIN;
            case "market":
                return MARKET;
            case "nonBudget":
                return NON_BUDGET;
            case "notFound":
                return NOT_FOUND;
            default:
                return null;
        }
    }
}
