package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 渠道类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-23
 */
public enum TenantTypeEnum {

    CENTRE_TENANT("centreTenant", "中心租户"),
    SMALL_TENANT("smallTenant", "小B租户");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TenantTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TenantTypeEnum fromCode(String code){
        switch(code) {
            case "centreTenant":
                return CENTRE_TENANT;
            case "smallTenant":
                return SMALL_TENANT;
            default:
                return null;
        }
    }
}
