package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * financial_basic_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-09-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialBasicBill implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 申请人编码
   */
  private String applicantNumber;
  /**
   * 申请人名称
   */
  private String applicantName;
  /**
   * 出差事由
   */
  private String travelReason;
  /**
   * 成本中心编码
   */
  private String costCenterCode;
  /**
   * 成本中心名称
   */
  private String costCenterName;
  /**
   * 项目所属区域编码
   */
  private String projectAreaCode;
  /**
   * 项目所属区域名称
   */
  private String projectAreaname;
  /**
   * KAM编码
   */
  private String kamCode;
  /**
   * KAM名称
   */
  private String kamName;
  /**
   * leader编码
   */
  private String leaderCode;
  /**
   * leader名称
   */
  private String leaderName;
  /**
   * 项目类别编码
   */
  private String projectTypeCode;
  /**
   * 项目类别名称
   */
  private String projectTypeName;
  /**
   * Owner编码
   */
  private String ownerCode;
  /**
   * Owner名称
   */
  private String ownerName;
  /**
   * 项目预算大类编码
   */
  private String projectBudgetTypeCode;
  /**
   * 项目预算大类名称
   */
  private String projectBudgetTypeName;
  /**
   * 员工邮箱​
   */
  private String staffEmail;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 单据模板
   */
  private String billTemplate;
  /**
   * 单据大类
   */
  private String billType;
  /**
   * 补充
   */
  private String newSupplement;
  /**
   * 补充申请名称
   */
  private String supplementaryApplicationName;
  /**
   * 补充申请编码
   */
  private String supplementaryApplicationCode;
  /**
   * 单据模板Code
   */
  private String billTemplateType;
  /**
   * 单据编号
   */
  private String billsNumber;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applicantNumber", applicantNumber);
      map.put("applicantName", applicantName);
      map.put("travelReason", travelReason);
      map.put("costCenterCode", costCenterCode);
      map.put("costCenterName", costCenterName);
      map.put("projectAreaCode", projectAreaCode);
      map.put("projectAreaname", projectAreaname);
      map.put("kamCode", kamCode);
      map.put("kamName", kamName);
      map.put("leaderCode", leaderCode);
      map.put("leaderName", leaderName);
      map.put("projectTypeCode", projectTypeCode);
      map.put("projectTypeName", projectTypeName);
      map.put("ownerCode", ownerCode);
      map.put("ownerName", ownerName);
      map.put("projectBudgetTypeCode", projectBudgetTypeCode);
      map.put("projectBudgetTypeName", projectBudgetTypeName);
      map.put("staffEmail", staffEmail);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billTemplate", billTemplate);
      map.put("billType", billType);
      map.put("newSupplement", newSupplement);
      map.put("supplementaryApplicationName", supplementaryApplicationName);
      map.put("supplementaryApplicationCode", supplementaryApplicationCode);
      map.put("billTemplateType", billTemplateType);
      map.put("billsNumber", billsNumber);

      return map;
  }

  public static FinancialBasicBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialBasicBill entity = new FinancialBasicBill();

    if(map.containsKey("applicantNumber")) {
      Object obj = map.get("applicantNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicantNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicantName")) {
      Object obj = map.get("applicantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelReason")) {
      Object obj = map.get("travelReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTravelReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenterCode")) {
      Object obj = map.get("costCenterCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenterCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenterName")) {
      Object obj = map.get("costCenterName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenterName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAreaCode")) {
      Object obj = map.get("projectAreaCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectAreaCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAreaname")) {
      Object obj = map.get("projectAreaname");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectAreaname((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKamCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamName")) {
      Object obj = map.get("kamName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKamName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaderCode")) {
      Object obj = map.get("leaderCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeaderCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaderName")) {
      Object obj = map.get("leaderName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeaderName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTypeCode")) {
      Object obj = map.get("projectTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTypeName")) {
      Object obj = map.get("projectTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectBudgetTypeCode")) {
      Object obj = map.get("projectBudgetTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectBudgetTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectBudgetTypeName")) {
      Object obj = map.get("projectBudgetTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectBudgetTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("staffEmail")) {
      Object obj = map.get("staffEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStaffEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billTemplate")) {
      Object obj = map.get("billTemplate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillTemplate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newSupplement")) {
      Object obj = map.get("newSupplement");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewSupplement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplementaryApplicationName")) {
      Object obj = map.get("supplementaryApplicationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplementaryApplicationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplementaryApplicationCode")) {
      Object obj = map.get("supplementaryApplicationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplementaryApplicationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billTemplateType")) {
      Object obj = map.get("billTemplateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillTemplateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billsNumber")) {
      Object obj = map.get("billsNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillsNumber((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("applicantNumber")) {
      Object obj = map.get("applicantNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplicantNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applicantName")) {
      Object obj = map.get("applicantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplicantName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("travelReason")) {
      Object obj = map.get("travelReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTravelReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("costCenterCode")) {
      Object obj = map.get("costCenterCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCostCenterCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("costCenterName")) {
      Object obj = map.get("costCenterName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCostCenterName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectAreaCode")) {
      Object obj = map.get("projectAreaCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectAreaCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectAreaname")) {
      Object obj = map.get("projectAreaname");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectAreaname((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKamCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("kamName")) {
      Object obj = map.get("kamName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKamName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("leaderCode")) {
      Object obj = map.get("leaderCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLeaderCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("leaderName")) {
      Object obj = map.get("leaderName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLeaderName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectTypeCode")) {
      Object obj = map.get("projectTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectTypeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectTypeName")) {
      Object obj = map.get("projectTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectTypeName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOwnerCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOwnerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectBudgetTypeCode")) {
      Object obj = map.get("projectBudgetTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectBudgetTypeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectBudgetTypeName")) {
      Object obj = map.get("projectBudgetTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectBudgetTypeName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("staffEmail")) {
      Object obj = map.get("staffEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStaffEmail((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billTemplate")) {
      Object obj = map.get("billTemplate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillTemplate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("newSupplement")) {
      Object obj = map.get("newSupplement");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNewSupplement((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("supplementaryApplicationName")) {
      Object obj = map.get("supplementaryApplicationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplementaryApplicationName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("supplementaryApplicationCode")) {
      Object obj = map.get("supplementaryApplicationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplementaryApplicationCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billTemplateType")) {
      Object obj = map.get("billTemplateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillTemplateType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billsNumber")) {
      Object obj = map.get("billsNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillsNumber((String)obj);
        }
      } else{
      }
   }

  }

}
