package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票红冲标识
 * </p>
 *
 * @author ultraman
 * @since 2022-06-23
 */
public enum InvoiceRedFlagEnum {

    _0("0", "正常"),
    _1("1", "待红冲"),
    _3("3", "已红冲"),
    _2("2", "待部分红冲"),
    _5("5", "红冲票"),
    _4("4", "已部分红冲"),
    _10("10", "不可申请红字信息表");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceRedFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceRedFlagEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "3":
                return _3;
            case "2":
                return _2;
            case "5":
                return _5;
            case "4":
                return _4;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
