package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * financial_refund_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialRefundBill extends FinancialApplyBasicBill {

  /**
   * 退款事由
   */
  private String cause;
  /**
   * 需退款金额
   */
  private String refundAmount;
  /**
   * 客户名称
   */
  private String customerName;
  /**
   * 付款公司主体编码
   */
  private String claimCompanyCode;
  /**
   * 付款公司主体名称
   */
  private String claimCompanyName;
  /**
   * 退款项目编码
   */
  private String refundProjectCode;
  /**
   * 退款项目名称
   */
  private String refundProjectName;
  /**
   * 退款理由编码
   */
  private String refundCauseCode;
  /**
   * 退款理由名称
   */
  private String refundCauseName;
  /**
   * 退回发票选择
   */
  private String returnInvoice;
  /**
   * 理由补充说明
   */
  private String additionalRemarks;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("cause", cause);
      map.put("refundAmount", refundAmount);
      map.put("customerName", customerName);
      map.put("claimCompanyCode", claimCompanyCode);
      map.put("claimCompanyName", claimCompanyName);
      map.put("refundProjectCode", refundProjectCode);
      map.put("refundProjectName", refundProjectName);
      map.put("refundCauseCode", refundCauseCode);
      map.put("refundCauseName", refundCauseName);
      map.put("returnInvoice", returnInvoice);
      map.put("additionalRemarks", additionalRemarks);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static FinancialRefundBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialRefundBill entity = new FinancialRefundBill();

    entity.setParentByOQSMap(map);
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundAmount")) {
      Object obj = map.get("refundAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefundAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("claimCompanyCode")) {
      Object obj = map.get("claimCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("claimCompanyName")) {
      Object obj = map.get("claimCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundProjectCode")) {
      Object obj = map.get("refundProjectCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefundProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundProjectName")) {
      Object obj = map.get("refundProjectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefundProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundCauseCode")) {
      Object obj = map.get("refundCauseCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefundCauseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundCauseName")) {
      Object obj = map.get("refundCauseName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefundCauseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnInvoice")) {
      Object obj = map.get("returnInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("additionalRemarks")) {
      Object obj = map.get("additionalRemarks");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAdditionalRemarks((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map){
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map){
    super.setByOQSMap(map);
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String){
            this.setCause((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("refundAmount")) {
      Object obj = map.get("refundAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setRefundAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("claimCompanyCode")) {
      Object obj = map.get("claimCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setClaimCompanyCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("claimCompanyName")) {
      Object obj = map.get("claimCompanyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setClaimCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("refundProjectCode")) {
      Object obj = map.get("refundProjectCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setRefundProjectCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("refundProjectName")) {
      Object obj = map.get("refundProjectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setRefundProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("refundCauseCode")) {
      Object obj = map.get("refundCauseCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setRefundCauseCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("refundCauseName")) {
      Object obj = map.get("refundCauseName");
      if(obj != null) {
        if(obj instanceof String){
            this.setRefundCauseName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("returnInvoice")) {
      Object obj = map.get("returnInvoice");
      if(obj != null) {
        if(obj instanceof String){
            this.setReturnInvoice((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("additionalRemarks")) {
      Object obj = map.get("additionalRemarks");
      if(obj != null) {
        if(obj instanceof String){
            this.setAdditionalRemarks((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
