package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 活动类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ActivityType {

    _1("1", "客户推广"),
    _2("2", "对账及催款"),
    _3("3", "市场调研"),
    _4("4", "市场活动"),
    _5("5", "产品推广");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ActivityType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ActivityType fromCode(String code) {
        return Stream.of(ActivityType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
