package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票开具状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum BillStatus {

    _0("0", "待开具"),
    _1("1", "已开具"),
    _2("2", "已申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillStatus fromCode(String code) {
        return Stream.of(BillStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
