package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据模板
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum BillTemplate {

    FINANCIAL_TRAVEL_APPLY_BILL("financialTravelApplyBill", "差旅申请单"),
    FINANCIAL_BUSINESS_SERVE_APPLY_BILL("financialBusinessServeApplyBill", "业务招待申请单"),
    FINANCIAL_TRAVEL_REIMBURSEMENT_BILL("financialTravelReimbursementBill", "差旅报销单"),
    FINANCIAL_CITY_REIMBURSEMENT_BILL("financialCityReimbursementBill", "市内交通费报销单"),
    FINANCIAL_BUSINESS_SERVE_REIMBURSEMENT_BILL("financialBusinessServeReimbursementBill", "业务招待报销单"),
    FINANCIAL_HES_WRITEOFF_BILL("financialHesWriteoffBill", "合思订单核销单"),
    FINANCIAL_TEAM_BUILDING_BILL("financialTeamBuildingBill", "团建费报销单"),
    FINANCIAL_PURCHASE_BILL("financialPurchaseBill", "采购申请单"),
    FINANCIAL_DAILY_BILL("financialDailyBill", "日常报销单"),
    FINANCIAL_PURCHASE_CONTRACT_BILL("financialPurchaseContractBill", "采购合同申请单"),
    FINANCIAL_PURCHASE_CHECK_BILL("financialPurchaseCheckBill", "采购验收单"),
    FINANCIAL_PERSON_LOAN_BILL("financialPersonLoanBill", "个人借款申请单"),
    FINANCIAL_PERSON_LOAN_BACK_BILL("financialPersonLoanBackBill", "个人借款归还单"),
    FINANCIAL_PURCHASE_PAYMENT_BILL("financialPurchasePaymentBill", "采购付款申请单"),
    FINANCIAL_REFUND_BILL("financialRefundBill", "退款申请单"),
    FINANCIAL_ASSETS_BILL("financialAssetsBill", "资产的领用及更换申请单"),
    FINANCIAL_ASSETS_BACK_BILL("financialAssetsBackBill", "资产的归还申请单"),
    FINANCIAL_INVOICE_PLEDGE_BILL("financialInvoicePledgeBill", "发票押金核销单"),
    FINANCIAL_ASSETS_TRANSFER_BILL("financialAssetsTransferBill", "资产调拨转移申请单"),
    FINANCIAL_PURCHASE_AFTER_SALE_BILL("financialPurchaseAfterSaleBill", "采购售后申请单"),
    FINANCIAL_KEEPER_CHANGE_BILL("financialKeeperChangeBill", "保管人变更申请单"),
    FINANCIAL_RESPONSIBLE_CHANGE_BILL("financialResponsibleChangeBill", "责任人变更"),
    FINANCIAL_INVENTORY_SALE_DELIVERY_BILL("financialInventorySaleDeliveryBill", "存货销售出库申请单"),
    FINANCIAL_SALE_RETURN_BILL("financialSaleReturnBill", "销售退回退库申请单"),
    FINANCIAL_PURCH_ASASSET_BORROW_BILL("financialPurchAsassetBorrowBill", "生产性资产借用申请单"),
    FINANCIAL_ASSEMBLE_BILL("financialAssembleBill", "装配申请单"),
    FINANCIAL_DISASSEMBLY_BILL("financialDisassemblyBill", "拆卸申请单"),
    FINANCIAL_TRANSFER_BILL("financialTransferBill", "转库申请单"),
    FINANCIAL_ACCESSORIESR_REPLACE_BILL("financialAccessoriesrReplaceBill", "配件补领或替换申请单"),
    FINANCIAL_ASSET_CHECK_BILL("financialAssetCheckBill", "资产盘点申请单"),
    FINANCIAL_ASSET_SCRAP_BILL("financialAssetScrapBill", "资产报废及处理申请单"),
    FINANCIAL_SALARY_BILL("financialSalaryBill", "薪资申请单"),
    FINANCIAL_INVOICE_CHECK_BILL("financialInvoiceCheckBill", "发票核销单"),
    FINANCIAL_LABOR_UNION_BILL("financialLaborUnionBill", "工会申请单"),
    FINANCIAL_PURCHASE_RED_ADJUST_BILL("financialPurchaseRedAdjustBill", "采购红冲调整单"),
    FINANCIAL_PROJECT_SHARE_ADJUST_BILL("financialProjectShareAdjustBill", "项目分摊调整单"),
    FINANCIAL_COST_TYPE_ADJUST_BILL("financialCostTypeAdjustBill", "费用类型调整单"),
    FINANCIAL_RF_OTHER("financialRfOther", "退款申请单「其他」");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillTemplate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTemplate fromCode(String code) {
        return Stream.of(BillTemplate.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
