package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据模本明细
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum BillTemplateDetail {

    FINANCIAL_TRAVEL_APPLY_BILL_DETAIL("financialTravelApplyBillDetail", "差旅申请单"),
    FINANCIAL_TRAVEL_BILL_DETAIL("financialTravelBillDetail", "差旅报销单"),
    FINANCIAL_CITY_BILL_DETAIL("financialCityBillDetail", "市内交通费报销单"),
    FINANCIAL_BUSINESS_SERVE_BILL_DETAIL("financialBusinessServeBillDetail", "业务招待报销单"),
    FINANCIAL_HES_WRITEOFF_BILL_DETAIL("financialHesWriteoffBillDetail", "合思订单核销单"),
    FINANCIAL_PURCHASE_BILL_DETAIL("financialPurchaseBillDetail", "采购申请单"),
    FINANCIAL_TEAM_BUILDING_BILL_DETAIL("financialTeamBuildingBillDetail", "团建费报销单"),
    FINANCIAL_DAILY_BILL_DETAIL("financialDailyBillDetail", "日常报销单"),
    FINANCIAL_PERSON_LOAN_BILL_DETAIL("financialPersonLoanBillDetail", "个人借款申请单"),
    FINANCIAL_PERSON_LOAN_BACK_BILL_DETAIL("financialPersonLoanBackBillDetail", "个人借款归还单"),
    FINANCIAL_REFUND_BILL_DETAIL("financialRefundBillDetail", "退款申请单"),
    FINANCIAL_PURCHASE_PAYMENT_BILL_DETAIL("financialPurchasePaymentBillDetail", "采购付款申请单"),
    FINANCIAL_ASSETS_BILL_DETAIL("financialAssetsBillDetail", "资产的领用及更换申请单"),
    FINANCIAL_ASSETS_BACK_BILL_DETAIL("financialAssetsBackBillDetail", "资产的归还申请单"),
    FINANCIAL_INVOICE_PLEDGE_BILL_DETAIL("financialInvoicePledgeBillDetail", "发票押金核销单"),
    FINANCIAL_ASSETS_TRANSFER_BILL_DETAIL("financialAssetsTransferBillDetail", "资产调拨转移申请单"),
    FINANCIAL_KEEPER_CHANGE_BILL_DETAIL("financialKeeperChangeBillDetail", "保管人变更申请单"),
    FINANCIAL_SALARY_BILL_DETAIL("financialSalaryBillDetail", "薪资申请单"),
    FINANCIAL_INVOICE_CHECK_BILL_DETAIL("financialInvoiceCheckBillDetail", "发票核销单"),
    FINANCIAL_LABOR_UNION_BILL_DETAIL("financialLaborUnionBillDetail", "工会申请单"),
    FINANCIAL_PURCHASE_RED_ADJUST_BILL_DETAIL("financialPurchaseRedAdjustBillDetail", "采购红冲调整单"),
    FINANCIAL_PROJECT_SHARE_ADJUST_BILL_DETAIL("financialProjectShareAdjustBillDetail", "项目分摊调整单"),
    FINANCIAL_COST_TYPE_ADJUST_BILL_DETAIL("financialCostTypeAdjustBillDetail", "费用类型调整单"),
    FINANCIAL_RF_OTHER_DETAIL("financialRfOtherDetail", "退款申请单「其他」");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillTemplateDetail(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTemplateDetail fromCode(String code) {
        return Stream.of(BillTemplateDetail.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
