package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 项目类别编码
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ChargeCodeType {

    _1("1", "BU"),
    _2("2", "交付"),
    _3("3", "交付部"),
    _4("4", "产品"),
    _5("5", "人事部"),
    _6("6", "客户"),
    _7("7", "客户服务部"),
    _8("8", "小B运营"),
    _9("9", "总裁办"),
    _10("10", "战略运营中心"),
    _11("11", "数据增值"),
    _12("12", "机会"),
    _13("13", "售前"),
    _14("14", "生态业务筹备组"),
    _15("15", "研发"),
    _16("16", "综合管理"),
    _17("17", "解决方案"),
    _18("18", "财务"),
    _19("19", "销售"),
    _20("20", "培训"),
    _21("21", "休假"),
    _22("22", "空闲"),
    CSM("CSM", "CSM"),
    PE("PE", "商联");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeCodeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeType fromCode(String code) {
        return Stream.of(ChargeCodeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
