package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费维度
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ChargeDimension {

    _0("0", "打包价(税号)"),
    _1("1", "打包价(限量)"),
    _2("2", "单价");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeDimension(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeDimension fromCode(String code) {
        return Stream.of(ChargeDimension.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
