package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 规则类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ChargeRuleType {

    _0("0", "按比例"),
    _1("1", "按用量"),
    _2("2", "按动态单价");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeRuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeRuleType fromCode(String code) {
        return Stream.of(ChargeRuleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
