package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ChargeTypeEnum {

    _1("1", "按照租户打包价"),
    _2("2", "按照税号打包价"),
    _3("3", "单价"),
    _4("4", "阶梯价"),
    _5("5", "打包价按业务维度"),
    _6("6", "租户打包价按业务维度"),
    _7("7", "按业务维度阶梯");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeTypeEnum fromCode(String code) {
        return Stream.of(ChargeTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
