package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费时间生效标识
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ChargeVaildLogo {

    SIGN("sign", "签订"),
    VALIDATION("validation", "验收"),
    USING_TIME("usingTime", "使用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeVaildLogo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeVaildLogo fromCode(String code) {
        return Stream.of(ChargeVaildLogo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
