package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 补偿类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum CompensateEnum {

    INVOICE("INVOICE", "发票"),
    TAX_NO("TAX_NO", "税号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CompensateEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompensateEnum fromCode(String code) {
        return Stream.of(CompensateEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
