package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 合同类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ContractTypes {

    _0("0", "主合同"),
    _1("1", "补充协议"),
    _2("2", "续费合同"),
    _3("3", "战略合作框架合同"),
    _4("4", "试用合同"),
    _5("5", "平台对接合同"),
    _6("6", "提前进场"),
    _7("7", "采购合同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ContractTypes(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractTypes fromCode(String code) {
        return Stream.of(ContractTypes.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
