package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 成本类型标识
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum CostType {

    _0("0", "无"),
    _1("1", "分润成本"),
    _2("2", "通道成本"),
    _3("3", "冲减研发费用"),
    _4("4", "硬件采购成本"),
    _5("5", "转包成本");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CostType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CostType fromCode(String code) {
        return Stream.of(CostType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
