package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 对公对私枚举
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ForIndividEnum {

    _0("0", "对公"),
    _1("1", "对私");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ForIndividEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ForIndividEnum fromCode(String code) {
        return Stream.of(ForIndividEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
