package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum InvoiceTypeEnum {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    V("v", "机动车销售发票"),
    T("t", "通用机打发票"),
    CE("ce", "增值税电子普通发票"),
    JU("ju", "增值税普通发票(卷票)"),
    CEB("ceb", "电子普通发票(区块链)"),
    QS("qs", "电子发票(增值税专用发票)"),
    QC("qc", "电子发票(普通发票)");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeEnum fromCode(String code) {
        return Stream.of(InvoiceTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
