package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 人员状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum MemberStatusEnum {

    _1("1", "在职"),
    _2("2", "试用"),
    _3("3", "正式"),
    _4("4", "调出"),
    _5("5", "待调入"),
    _6("6", "退休"),
    _8("8", "离职"),
    _12("12", "非正式");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MemberStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MemberStatusEnum fromCode(String code) {
        return Stream.of(MemberStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
