package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum MultiRelationDetailEnum {

    NORMAL("normal", "正常"),
    CP_ORDER_TAX("cpOrderTax", "补偿-订单税号"),
    CP_ORDER_INVOICE("cpOrderInvoice", "补偿-订单发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MultiRelationDetailEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MultiRelationDetailEnum fromCode(String code) {
        return Stream.of(MultiRelationDetailEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
