package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 回款流水数据来源枚举
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum NotTakenChannelEnum {

    IMPORT("import", "文件导入"),
    NBCB("nbcb", "宁波银行");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NotTakenChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NotTakenChannelEnum fromCode(String code) {
        return Stream.of(NotTakenChannelEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
