package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 新旧枚举值
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum OLDNEWENUM {

    _0("0", "旧"),
    _1("1", "新");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OLDNEWENUM(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OLDNEWENUM fromCode(String code) {
        return Stream.of(OLDNEWENUM.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
