package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 回款的支付状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum PayStatus {

    CANCEL("CANCEL", "已作废"),
    UN_PAID("UN_PAID", "未支付"),
    PAID("PAID", "已支付"),
    UN_CANCEL("UN_CANCEL", "未作废"),
    PART_PAY("PART_PAY", "部分支付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PayStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayStatus fromCode(String code) {
        return Stream.of(PayStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
