package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款条件
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum PaymentRequirement {

    _1("1", "合同签订"),
    _3("3", "UAT测试"),
    _2("2", "蓝图确认"),
    _4("4", "上线验收"),
    _5("5", "质保金"),
    _6("6", "开通服务"),
    _0("0", "其他"),
    _7("7", "上线"),
    _8("8", "验收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PaymentRequirement(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentRequirement fromCode(String code) {
        return Stream.of(PaymentRequirement.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
