package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品型号
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ProductType {

    _0("0", "无"),
    _1("1", "M1200"),
    _2("2", "S825"),
    _3("3", "次年"),
    _4("4", "首年"),
    _5("5", "60口"),
    _6("6", "90口"),
    _7("7", "黑色碳粉盒"),
    _8("8", "红色碳粉盒"),
    _9("9", "黑色硒鼓"),
    _10("10", "红色硒鼓"),
    _11("11", "BO378"),
    _12("12", "jmr139"),
    _13("13", "P355-K20"),
    _14("14", "D80-3"),
    _15("15", "UEX-20"),
    _16("16", "PYT241-19"),
    _17("17", "UEX-60A"),
    _18("18", "硒鼓耗材"),
    _19("19", "一般计税"),
    _20("20", "混合计税"),
    _21("21", "简易计税"),
    _22("22", "打印机针头"),
    _23("23", "L7350"),
    _24("24", "打印机塑料条"),
    _25("25", "电源"),
    _26("26", "分页轮"),
    _27("27", "色带"),
    _28("28", "DF241-10"),
    _29("29", "粉盒硒鼓"),
    _30("30", "霍尼韦尔 1900GHD"),
    _31("31", "科密 EW-9200"),
    _32("32", "发票章"),
    _33("33", "搓纸滚轮"),
    _34("34", "齿轮"),
    _35("35", "打印机拖链");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProductType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductType fromCode(String code) {
        return Stream.of(ProductType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
