package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 行业
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum Profession {

    _1("1", "地产"),
    _2("2", "零售"),
    _3("3", "物流"),
    _4("4", "通用"),
    _5("5", "数据增值服务"),
    _6("6", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Profession(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Profession fromCode(String code) {
        return Stream.of(Profession.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
