package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 项目阶段状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum ProjectStageStatus {

    NOT_STARTING("notStarting", "未开始"),
    PROCESSING("processing", "进行中"),
    FINISHED("finished", "已完成"),
    STOP("stop", "已终止");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProjectStageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProjectStageStatus fromCode(String code) {
        return Stream.of(ProjectStageStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
