package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 性质
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum Property {

    ONE_TIME("oneTime", "一次性"),
    CONTINUITY("continuity", "持续性");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Property(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Property fromCode(String code) {
        return Stream.of(Property.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
