package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 大区
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum Region {

    _0("0", "华东"),
    _1("1", "南区"),
    _2("2", "北区"),
    _3("3", "中区"),
    _4("4", "GR"),
    _5("5", "总部"),
    _6("6", "光是"),
    _7("7", "数据增值服务BG筹备组");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Region(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Region fromCode(String code) {
        return Stream.of(Region.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
