package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 查询方式
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum SearchType {

    ORDER("order", "订单"),
    INVOICE("invoice", "发票"),
    TAX("tax", "税号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SearchType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SearchType fromCode(String code) {
        return Stream.of(SearchType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
