package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 结算条件
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum SettlementCondition {

    _1("1", "开通服务"),
    _2("2", "验收"),
    _3("3", "首次使用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SettlementCondition(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementCondition fromCode(String code) {
        return Stream.of(SettlementCondition.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
