package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 小B映射表合同状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum SmallContractStatusMapping {

    _0("0", "失效"),
    _1("1", "有效");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SmallContractStatusMapping(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallContractStatusMapping fromCode(String code) {
        return Stream.of(SmallContractStatusMapping.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
