package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 小B下单方式
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum SmallOrderWay {

    _1("1", "直接购买"),
    _2("2", "接口下单"),
    _3("3", "导入下单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SmallOrderWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallOrderWay fromCode(String code) {
        return Stream.of(SmallOrderWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
