package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开始计费条件
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum StartChargeCondition {

    _1("1", "验收单签署日期"),
    _2("2", "第一次使用业务功能日期");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StartChargeCondition(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StartChargeCondition fromCode(String code) {
        return Stream.of(StartChargeCondition.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
