package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 提交状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum SubStat {

    _0("0", "无需分摊"),
    _1("1", "已提交"),
    _2("2", "已分摊"),
    _3("3", "未分摊");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SubStat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubStat fromCode(String code) {
        return Stream.of(SubStat.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
