package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 差旅费用承担方
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum TravelExpensesBearer {

    _0("0", "甲方"),
    _1("1", "乙方");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TravelExpensesBearer(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TravelExpensesBearer fromCode(String code) {
        return Stream.of(TravelExpensesBearer.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
