package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * charge_month_data
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeMonthData implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同编号
   */
  private String contractCode;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 产品编码
   */
  private String productCode;
  /**
   * 租户的标识
   */
  private String tenantCode;
  /**
   * 租户的名称
   */
  private String tenantName;
  /**
   * 公司税号
   */
  private String taxNum;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 服务开通标识
   */
  private String serviceOpenFlag;
  /**
   * 结算开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;
  /**
   * 结算结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;
  /**
   * 使用月份
   */
  private String billMonth;
  /**
   * 计费类型
   */
  private String billingType;
  /**
   * 计费项
   */
  private String businessCode;
  /**
   * 计费业务量
   */
  private Long usageCount;
  /**
   * 限制业务量
   */
  private Long usageLimitCount;
  /**
   * 计费金额（不含税）
   */
  private BigDecimal billAmountWithoutTax;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 售价（不含税）
   */
  private BigDecimal priceUnit;
  /**
   * 付费方式-原始值
   */
  private Long paymentType;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 租户code
   */
  private String bTenantCode;
  /**
   * 租户名称
   */
  private String bTenantName;
  /**
   * 月流水Id
   */
  private Long flowId;
  /**
   * 公司税号(判重字段)-PK
   */
  private String taxNumPk;
  /**
   * 税号计费开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxStartDate;
  /**
   * 税号计费结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxEndDate;
  /**
   * 原始合同编号
   */
  private String originContractCode;
  /**
   * 付费方式
   */
  private String paymentTypeEnum;
  /**
   * 设备类型
   */
  private String deviceType;
  /**
   * 设备编号
   */
  private String deviceNo;
  /**
   * 计费周期
   */
  private String cycle;
  /**
   * 计费周期单位
   */
  private Long period;
  /**
   * 设备开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deviceStartDate;
  /**
   * 设备结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deviceEndDate;
  /**
   * 设备类型(判重字段)-PK
   */
  private String deviceTypePk;
  /**
   * 设备编号(判重字段)
   */
  private String deviceNoPk;
  /**
   * 收入调整状态
   */
  private String adjustStatus;
  /**
   * 结算周期结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime cycleEndDate;
  /**
   * 结算周期开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime cycleStartDate;
  /**
   * 计费类型二级分类
   */
  private String tieredDimension;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("contractCode", contractCode);
      map.put("productName", productName);
      map.put("productCode", productCode);
      map.put("tenantCode", tenantCode);
      map.put("tenantName", tenantName);
      map.put("taxNum", taxNum);
      map.put("companyName", companyName);
      map.put("serviceOpenFlag", serviceOpenFlag);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("billMonth", billMonth);
      map.put("billingType", billingType);
      map.put("businessCode", businessCode);
      map.put("usageCount", usageCount);
      map.put("usageLimitCount", usageLimitCount);
      map.put("billAmountWithoutTax", billAmountWithoutTax);
      map.put("taxRate", taxRate);
      map.put("priceUnit", priceUnit);
      map.put("paymentType", paymentType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bTenantCode", bTenantCode);
      map.put("bTenantName", bTenantName);
      map.put("flowId", flowId);
      map.put("taxNumPk", taxNumPk);
      map.put("taxStartDate", BocpGenUtils.toTimestamp(taxStartDate));
      map.put("taxEndDate", BocpGenUtils.toTimestamp(taxEndDate));
      map.put("originContractCode", originContractCode);
      map.put("paymentTypeEnum", paymentTypeEnum);
      map.put("deviceType", deviceType);
      map.put("deviceNo", deviceNo);
      map.put("cycle", cycle);
      map.put("period", period);
      map.put("deviceStartDate", BocpGenUtils.toTimestamp(deviceStartDate));
      map.put("deviceEndDate", BocpGenUtils.toTimestamp(deviceEndDate));
      map.put("deviceTypePk", deviceTypePk);
      map.put("deviceNoPk", deviceNoPk);
      map.put("adjustStatus", adjustStatus);
      map.put("cycleEndDate", BocpGenUtils.toTimestamp(cycleEndDate));
      map.put("cycleStartDate", BocpGenUtils.toTimestamp(cycleStartDate));
      map.put("tieredDimension", tieredDimension);

      return map;
  }

  public static ChargeMonthData fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeMonthData entity = new ChargeMonthData();

    if(map.containsKey("contractCode")) {
      Object obj = map.get("contractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNum")) {
      Object obj = map.get("taxNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceOpenFlag")) {
      Object obj = map.get("serviceOpenFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceOpenFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("billMonth")) {
      Object obj = map.get("billMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessCode")) {
      Object obj = map.get("businessCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usageCount")) {
      Object obj = map.get("usageCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsageCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUsageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("usageLimitCount")) {
      Object obj = map.get("usageLimitCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsageLimitCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUsageLimitCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsageLimitCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("billAmountWithoutTax")) {
      Object obj = map.get("billAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priceUnit")) {
      Object obj = map.get("priceUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPriceUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPriceUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPriceUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaymentType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantName")) {
      Object obj = map.get("bTenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowId")) {
      Object obj = map.get("flowId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFlowId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFlowId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFlowId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("taxNumPk")) {
      Object obj = map.get("taxNumPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNumPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxStartDate")) {
      Object obj = map.get("taxStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxStartDate(null);
      }
    }
    if(map.containsKey("taxEndDate")) {
      Object obj = map.get("taxEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxEndDate(null);
      }
    }
    if(map.containsKey("originContractCode")) {
      Object obj = map.get("originContractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTypeEnum")) {
      Object obj = map.get("paymentTypeEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentTypeEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cycle")) {
      Object obj = map.get("cycle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("period")) {
      Object obj = map.get("period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPeriod((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deviceStartDate")) {
      Object obj = map.get("deviceStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeviceStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeviceStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeviceStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeviceStartDate(null);
      }
    }
    if(map.containsKey("deviceEndDate")) {
      Object obj = map.get("deviceEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeviceEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeviceEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeviceEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeviceEndDate(null);
      }
    }
    if(map.containsKey("deviceTypePk")) {
      Object obj = map.get("deviceTypePk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceTypePk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNoPk")) {
      Object obj = map.get("deviceNoPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNoPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("adjustStatus")) {
      Object obj = map.get("adjustStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAdjustStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cycleEndDate")) {
      Object obj = map.get("cycleEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCycleEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCycleEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCycleEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCycleEndDate(null);
      }
    }
    if(map.containsKey("cycleStartDate")) {
      Object obj = map.get("cycleStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCycleStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCycleStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCycleStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCycleStartDate(null);
      }
    }
    if(map.containsKey("tieredDimension")) {
      Object obj = map.get("tieredDimension");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTieredDimension((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("contractCode")) {
      Object obj = map.get("contractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNum")) {
      Object obj = map.get("taxNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceOpenFlag")) {
      Object obj = map.get("serviceOpenFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setServiceOpenFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndDate(null);
      }
    }
    if(map.containsKey("billMonth")) {
      Object obj = map.get("billMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessCode")) {
      Object obj = map.get("businessCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usageCount")) {
      Object obj = map.get("usageCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUsageCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUsageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUsageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("usageLimitCount")) {
      Object obj = map.get("usageLimitCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUsageLimitCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUsageLimitCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUsageLimitCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("billAmountWithoutTax")) {
      Object obj = map.get("billAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priceUnit")) {
      Object obj = map.get("priceUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPriceUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPriceUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPriceUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPriceUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPriceUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPaymentType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantName")) {
      Object obj = map.get("bTenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowId")) {
      Object obj = map.get("flowId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setFlowId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFlowId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setFlowId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("taxNumPk")) {
      Object obj = map.get("taxNumPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNumPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxStartDate")) {
      Object obj = map.get("taxStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTaxStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTaxStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTaxStartDate(null);
      }
    }
    if(map.containsKey("taxEndDate")) {
      Object obj = map.get("taxEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTaxEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTaxEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTaxEndDate(null);
      }
    }
    if(map.containsKey("originContractCode")) {
      Object obj = map.get("originContractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTypeEnum")) {
      Object obj = map.get("paymentTypeEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentTypeEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cycle")) {
      Object obj = map.get("cycle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("period")) {
      Object obj = map.get("period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPeriod((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deviceStartDate")) {
      Object obj = map.get("deviceStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeviceStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeviceStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeviceStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeviceStartDate(null);
      }
    }
    if(map.containsKey("deviceEndDate")) {
      Object obj = map.get("deviceEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeviceEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeviceEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeviceEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeviceEndDate(null);
      }
    }
    if(map.containsKey("deviceTypePk")) {
      Object obj = map.get("deviceTypePk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceTypePk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNoPk")) {
      Object obj = map.get("deviceNoPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceNoPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("adjustStatus")) {
      Object obj = map.get("adjustStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAdjustStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cycleEndDate")) {
      Object obj = map.get("cycleEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCycleEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCycleEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCycleEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCycleEndDate(null);
      }
    }
    if(map.containsKey("cycleStartDate")) {
      Object obj = map.get("cycleStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCycleStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCycleStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCycleStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCycleStartDate(null);
      }
    }
    if(map.containsKey("tieredDimension")) {
      Object obj = map.get("tieredDimension");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTieredDimension((String)obj);
        }
      } else{
      }
    }
  }
}
