package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * contract_tax_no_detail
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ContractTaxNoDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同号
   */
  private String contractCode;
  /**
   * 产品code
   */
  private String productCode;
  /**
   * 订单号-作废
   */
  private String orderId;
  /**
   * 公司税号
   */
  private String taxNum;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 原始合同id
   */
  private String contractId;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 操作类型-作废
   */
  private String operateType;
  /**
   * 开通时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime serviceOpenTime;
  /**
   * 关闭时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime serviceStopTime;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 开始计费时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startChargeTime;
  /**
   * 设备类型枚举
   */
  private String deviceType;
  /**
   * 设备编号
   */
  private String deviceNo;
  /**
   * 设备类型判重字段-内部
   */
  private String deviceTypePk;
  /**
   * 设备编号判重字段-内部
   */
  private String deviceNoPk;
  /**
   * 维护渠道
   */
  private String channel;

  /**
   * 对一关联关系 关联对象 taxNoList
   */
  private Long oneTaxNolistMultipleContractTaxNoId;
  /**
   * 对一关联关系 关联对象 contract
   */
  private Long oneContractIdMultipleContractTaxNoDetailId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("contractCode", contractCode);
      map.put("productCode", productCode);
      map.put("orderId", orderId);
      map.put("taxNum", taxNum);
      map.put("companyName", companyName);
      map.put("contractId", contractId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("operateType", operateType);
      map.put("serviceOpenTime", BocpGenUtils.toTimestamp(serviceOpenTime));
      map.put("serviceStopTime", BocpGenUtils.toTimestamp(serviceStopTime));
      map.put("productName", productName);
      map.put("startChargeTime", BocpGenUtils.toTimestamp(startChargeTime));
      map.put("deviceType", deviceType);
      map.put("deviceNo", deviceNo);
      map.put("deviceTypePk", deviceTypePk);
      map.put("deviceNoPk", deviceNoPk);
      map.put("channel", channel);

      map.put("oneTaxNolistMultipleContractTaxNo.id", oneTaxNolistMultipleContractTaxNoId);
      map.put("oneContractIdMultipleContractTaxNoDetail.id", oneContractIdMultipleContractTaxNoDetailId);
      return map;
  }

  public static ContractTaxNoDetail fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ContractTaxNoDetail entity = new ContractTaxNoDetail();

    if(map.containsKey("contractCode")) {
      Object obj = map.get("contractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNum")) {
      Object obj = map.get("taxNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operateType")) {
      Object obj = map.get("operateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceOpenTime")) {
      Object obj = map.get("serviceOpenTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setServiceOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setServiceOpenTime(null);
      }
    }
    if(map.containsKey("serviceStopTime")) {
      Object obj = map.get("serviceStopTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceStopTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setServiceStopTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceStopTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setServiceStopTime(null);
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startChargeTime")) {
      Object obj = map.get("startChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartChargeTime(null);
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceTypePk")) {
      Object obj = map.get("deviceTypePk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceTypePk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNoPk")) {
      Object obj = map.get("deviceNoPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNoPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("oneTaxNolistMultipleContractTaxNo.id")) {
       Object obj = map.get("oneTaxNolistMultipleContractTaxNo.id");
       if(obj instanceof Long) {
         entity.setOneTaxNolistMultipleContractTaxNoId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOneTaxNolistMultipleContractTaxNoId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("oneContractIdMultipleContractTaxNoDetail.id")) {
       Object obj = map.get("oneContractIdMultipleContractTaxNoDetail.id");
       if(obj instanceof Long) {
         entity.setOneContractIdMultipleContractTaxNoDetailId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOneContractIdMultipleContractTaxNoDetailId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("contractCode")) {
      Object obj = map.get("contractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNum")) {
      Object obj = map.get("taxNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operateType")) {
      Object obj = map.get("operateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOperateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceOpenTime")) {
      Object obj = map.get("serviceOpenTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setServiceOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setServiceOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setServiceOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setServiceOpenTime(null);
      }
    }
    if(map.containsKey("serviceStopTime")) {
      Object obj = map.get("serviceStopTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setServiceStopTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setServiceStopTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setServiceStopTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setServiceStopTime(null);
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startChargeTime")) {
      Object obj = map.get("startChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStartChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartChargeTime(null);
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceTypePk")) {
      Object obj = map.get("deviceTypePk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceTypePk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNoPk")) {
      Object obj = map.get("deviceNoPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceNoPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChannel((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("oneTaxNolistMultipleContractTaxNo.id")) {
    Object obj = map.get("oneTaxNolistMultipleContractTaxNo.id");
    if(obj instanceof Long) {
        this.setOneTaxNolistMultipleContractTaxNoId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOneTaxNolistMultipleContractTaxNoId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("oneContractIdMultipleContractTaxNoDetail.id")) {
    Object obj = map.get("oneContractIdMultipleContractTaxNoDetail.id");
    if(obj instanceof Long) {
        this.setOneContractIdMultipleContractTaxNoDetailId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOneContractIdMultipleContractTaxNoDetailId(Long.parseLong((String)obj));
    }
  }
  }
}
