package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * small_business_income
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SmallBusinessIncome implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 订单号
   */
  private String orderNo;
  /**
   * 中心客户名称
   */
  private String customerName;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 签约客户
   */
  private String signCustomerName;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 使用公司名称
   */
  private String companyName;
  /**
   * 使用公司税号
   */
  private String companyTaxNo;
  /**
   * 标的
   */
  private String targetObject;
  /**
   * 使用月份
   */
  private String useMonth;
  /**
   * 会计期间
   */
  private String chargeMonth;
  /**
   * 实际服务开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;
  /**
   * 预计服务结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime predictEndDate;
  /**
   * 实际服务结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;
  /**
   *  回款金额 
   */
  private BigDecimal returnedAmount;
  /**
   *  当期收入 
   */
  private BigDecimal currentAmount;
  /**
   * 订单id
   */
  private Long orderId;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 产品税率
   */
  private BigDecimal taxRate;
  /**
   *  当期含税收入
   */
  private BigDecimal currentAmountWithTax;
  /**
   * 每月有效计费天数
   */
  private Long validDays;
  /**
   * 日单价
   */
  private BigDecimal dayPrice;
  /**
   * 来源
   */
  private String source;
  /**
   * 使用开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime useStartDate;
  /**
   * 使用结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime useEndDate;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("customerName", customerName);
      map.put("contractNo", contractNo);
      map.put("signCustomerName", signCustomerName);
      map.put("projectName", projectName);
      map.put("companyName", companyName);
      map.put("companyTaxNo", companyTaxNo);
      map.put("targetObject", targetObject);
      map.put("useMonth", useMonth);
      map.put("chargeMonth", chargeMonth);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("predictEndDate", BocpGenUtils.toTimestamp(predictEndDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("returnedAmount", returnedAmount);
      map.put("currentAmount", currentAmount);
      map.put("orderId", orderId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("taxRate", taxRate);
      map.put("currentAmountWithTax", currentAmountWithTax);
      map.put("validDays", validDays);
      map.put("dayPrice", dayPrice);
      map.put("source", source);
      map.put("useStartDate", BocpGenUtils.toTimestamp(useStartDate));
      map.put("useEndDate", BocpGenUtils.toTimestamp(useEndDate));

      return map;
  }

  public static SmallBusinessIncome fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    SmallBusinessIncome entity = new SmallBusinessIncome();

    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signCustomerName")) {
      Object obj = map.get("signCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetObject")) {
      Object obj = map.get("targetObject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useMonth")) {
      Object obj = map.get("useMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUseMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("predictEndDate")) {
      Object obj = map.get("predictEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPredictEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPredictEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPredictEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPredictEndDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("returnedAmount")) {
      Object obj = map.get("returnedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentAmount")) {
      Object obj = map.get("currentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentAmountWithTax")) {
      Object obj = map.get("currentAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("validDays")) {
      Object obj = map.get("validDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setValidDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setValidDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setValidDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dayPrice")) {
      Object obj = map.get("dayPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDayPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDayPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDayPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDayPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDayPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useStartDate")) {
      Object obj = map.get("useStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUseStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUseStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUseStartDate(null);
      }
    }
    if(map.containsKey("useEndDate")) {
      Object obj = map.get("useEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUseEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUseEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUseEndDate(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signCustomerName")) {
      Object obj = map.get("signCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSignCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetObject")) {
      Object obj = map.get("targetObject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTargetObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useMonth")) {
      Object obj = map.get("useMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUseMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartDate(null);
      }
    }
    if(map.containsKey("predictEndDate")) {
      Object obj = map.get("predictEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPredictEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPredictEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPredictEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPredictEndDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndDate(null);
      }
    }
    if(map.containsKey("returnedAmount")) {
      Object obj = map.get("returnedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReturnedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReturnedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReturnedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReturnedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReturnedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentAmount")) {
      Object obj = map.get("currentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCurrentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCurrentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCurrentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCurrentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCurrentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentAmountWithTax")) {
      Object obj = map.get("currentAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCurrentAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCurrentAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCurrentAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCurrentAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCurrentAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("validDays")) {
      Object obj = map.get("validDays");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setValidDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setValidDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setValidDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dayPrice")) {
      Object obj = map.get("dayPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDayPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDayPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDayPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDayPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDayPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useStartDate")) {
      Object obj = map.get("useStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUseStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUseStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUseStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUseStartDate(null);
      }
    }
    if(map.containsKey("useEndDate")) {
      Object obj = map.get("useEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUseEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUseEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUseEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUseEndDate(null);
      }
    }
  }
}
