package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * tax_no_list
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TaxNoList implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 税号
   */
  private String taxNo;
  /**
   * 开始计费时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startChargeTime;
  /**
   * 服务停用日期-作废
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime stopTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 产品code
   */
  private String productCode;
  /**
   * 税号状态-作废
   */
  private String taxNoStatus;
  /**
   * 订单号
   */
  private String orderNo;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 服务开通日期-作废
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime openTime;
  /**
   * 设备类型
   */
  private String deviceType;
  /**
   * 设备编号
   */
  private String deviceNo;
  /**
   * 结算开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;
  /**
   * 结算结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;
  /**
   * 设备类型判重字段-内部
   */
  private String deviceTypePk;
  /**
   * 设备编号判重字段-内部
   */
  private String deviceNoPk;
  /**
   * 合同系统Id
   */
  private String originContractId;
  /**
   * 渠道类型
   */
  private String tenantType;

  /**
   * 对一关联关系 关联对象 contract
   */
  private Long oneContractMainToManyTaxNoListId;
  /**
   * 对一关联关系 关联对象 orderInfo
   */
  private Long oneOrderToMultipleTaxNolistId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("productName", productName);
      map.put("taxNo", taxNo);
      map.put("startChargeTime", BocpGenUtils.toTimestamp(startChargeTime));
      map.put("stopTime", BocpGenUtils.toTimestamp(stopTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("productCode", productCode);
      map.put("taxNoStatus", taxNoStatus);
      map.put("orderNo", orderNo);
      map.put("companyName", companyName);
      map.put("openTime", BocpGenUtils.toTimestamp(openTime));
      map.put("deviceType", deviceType);
      map.put("deviceNo", deviceNo);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("deviceTypePk", deviceTypePk);
      map.put("deviceNoPk", deviceNoPk);
      map.put("originContractId", originContractId);
      map.put("tenantType", tenantType);

      map.put("oneContractMainToManyTaxNoList.id", oneContractMainToManyTaxNoListId);
      map.put("oneOrderToMultipleTaxNolist.id", oneOrderToMultipleTaxNolistId);
      return map;
  }

  public static TaxNoList fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    TaxNoList entity = new TaxNoList();

    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startChargeTime")) {
      Object obj = map.get("startChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartChargeTime(null);
      }
    }
    if(map.containsKey("stopTime")) {
      Object obj = map.get("stopTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStopTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStopTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStopTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStopTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNoStatus")) {
      Object obj = map.get("taxNoStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openTime")) {
      Object obj = map.get("openTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOpenTime(null);
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("deviceTypePk")) {
      Object obj = map.get("deviceTypePk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceTypePk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNoPk")) {
      Object obj = map.get("deviceNoPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNoPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantType((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("oneContractMainToManyTaxNoList.id")) {
       Object obj = map.get("oneContractMainToManyTaxNoList.id");
       if(obj instanceof Long) {
         entity.setOneContractMainToManyTaxNoListId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOneContractMainToManyTaxNoListId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("oneOrderToMultipleTaxNolist.id")) {
       Object obj = map.get("oneOrderToMultipleTaxNolist.id");
       if(obj instanceof Long) {
         entity.setOneOrderToMultipleTaxNolistId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOneOrderToMultipleTaxNolistId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startChargeTime")) {
      Object obj = map.get("startChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStartChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartChargeTime(null);
      }
    }
    if(map.containsKey("stopTime")) {
      Object obj = map.get("stopTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStopTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStopTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStopTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStopTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNoStatus")) {
      Object obj = map.get("taxNoStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openTime")) {
      Object obj = map.get("openTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOpenTime(null);
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("deviceTypePk")) {
      Object obj = map.get("deviceTypePk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceTypePk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNoPk")) {
      Object obj = map.get("deviceNoPk");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceNoPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantType((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("oneContractMainToManyTaxNoList.id")) {
    Object obj = map.get("oneContractMainToManyTaxNoList.id");
    if(obj instanceof Long) {
        this.setOneContractMainToManyTaxNoListId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOneContractMainToManyTaxNoListId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("oneOrderToMultipleTaxNolist.id")) {
    Object obj = map.get("oneOrderToMultipleTaxNolist.id");
    if(obj instanceof Long) {
        this.setOneOrderToMultipleTaxNolistId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOneOrderToMultipleTaxNolistId(Long.parseLong((String)obj));
    }
  }
  }
}
