package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 用量分摊状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum AllocationStatus {

    _0("0", "未分摊"),
    _1("1", "已分摊");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AllocationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AllocationStatus fromCode(String code) {
        return Stream.of(AllocationStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
