package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum BillingType {

    _1("1", "按功能打包价"),
    _2("2", "按税号打包价"),
    _3("3", "按单价"),
    _4("4", "按阶梯价"),
    _5("5", "按量限制"),
    _6("6", "单价按数量");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillingType fromCode(String code) {
        return Stream.of(BillingType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
