package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum BusinessDimension {

    OTHER("other", "other");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessDimension(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessDimension fromCode(String code) {
        return Stream.of(BusinessDimension.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
