package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 回款核销规则类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum CapitalVerifyRuleType {

    _1("1", "自动核销"),
    _2("2", "自动查询");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CapitalVerifyRuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CapitalVerifyRuleType fromCode(String code) {
        return Stream.of(CapitalVerifyRuleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
