package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 项目所属区域
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ChargeCodeArea {

    _1("1", "华东"),
    _2("2", "华中"),
    _3("3", "北区"),
    _4("4", "南区"),
    _5("5", "光是"),
    _6("6", "数据增值服务、BG筹备组"),
    _7("7", "总部"),
    _8("8", "公司"),
    _10("10", "华东交付部"),
    _11("11", "华东大区KAM部"),
    _12("12", "华北大区KAM部"),
    CODE5("code5", "地产BU"),
    CODE6("code6", "零售 BU"),
    CODE7("code7", "产品部"),
    CODE9("code9", "综合管理部");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeCodeArea(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeArea fromCode(String code) {
        return Stream.of(ChargeCodeArea.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
