package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预算类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ChargeCodeBudgetType {

    PROJECT("project", "项目预算"),
    DEPT("dept", "部门预算");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeCodeBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeBudgetType fromCode(String code) {
        return Stream.of(ChargeCodeBudgetType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
