package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 收费方式
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ChargeType {

    PRE_PAID("prePaid", "预付"),
    POST_PAID("postPaid", "后付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeType fromCode(String code) {
        return Stream.of(ChargeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
