package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 合同有效期约定
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ContractAppoint {

    _0("0", "有期限，可自动延续"),
    _1("1", "有期限，无自动延续"),
    _2("2", "无期限，无自动延续"),
    _3("3", "未约定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ContractAppoint(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractAppoint fromCode(String code) {
        return Stream.of(ContractAppoint.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
