package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 合同状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ContractStatus {

    _1("1", "有效"),
    _2("2", "失效"),
    _3("3", "终止");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ContractStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractStatus fromCode(String code) {
        return Stream.of(ContractStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
